import { tassign } from 'tassign';
import {
  DISABLE_CONCEPT_NODE_VIEW,
  ENABLE_CONCEPT_NODE_VIEW
} from '../actions';

function disableConceptNodeView(state, action) {
  return tassign(state, {canViewNode: false});
}

function enableConceptNodeView(state, action) {
  return tassign(state, {canViewNode: true});
}

const INITIAL_STATE = {
  canViewNode: false
}

export default function conceptNodeReducer(state=INITIAL_STATE, action) {
  switch (action.type) {
    case DISABLE_CONCEPT_NODE_VIEW:
      return disableConceptNodeView(state, action);
    case ENABLE_CONCEPT_NODE_VIEW:
      return enableConceptNodeView(state, action);
  }
  return state;
}